/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.common.util.Crypt;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public class HSCTarFile {
    private String archiveFileName = null;
    private Vector archiveFileList = null;
    private int currentFilePointer = 0;
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("You must provide a filename for a tar file");
            return;
        }
        HSCTarFile hSCTarFile = null;
        try {
            hSCTarFile = new HSCTarFile(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("Exception from HSCTarFile c-tor: " + iOException);
            return;
        }
        System.out.println("Number of entries in " + stringArray[0] + " is " + hSCTarFile.size());
        Vector vector = hSCTarFile.listEntries();
        System.out.println("File list from listEntries()");
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println("  " + (String)vector.elementAt(i));
        }
        System.out.println("File list from getNextEntry()");
        String string = null;
        while ((string = hSCTarFile.getNextEntry()) != null) {
            System.out.println("  " + string);
        }
        try {
            hSCTarFile.restoreArchive();
        }
        catch (IOException iOException) {
            System.out.println("Exception from HSCTarFile restoreArchive: " + iOException);
            return;
        }
    }

    public HSCTarFile(String string) throws IOException {
        this.archiveFileName = string;
        String string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -tf " + this.archiveFileName;
        try {
            EExecResult eExecResult = EExec.Exec((String)string2);
            if (eExecResult.rc == 0 && eExecResult.stderr.length() == 0) {
                String string3 = eExecResult.stdout;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                String string4 = null;
                this.archiveFileList = new Vector();
                while ((string4 = bufferedReader.readLine()) != null) {
                    this.archiveFileList.addElement(string4);
                }
            } else {
                if (eExecResult.rc != 0) {
                    throw new IOException("tar -tf failure " + eExecResult.rc + "(" + eExecResult.stderr + ")");
                }
                throw new IOException("tar -tf failure (" + eExecResult.stderr + ")");
            }
            this.reset();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("EExec failure");
        }
    }

    public int size() {
        return this.archiveFileList.size();
    }

    public String getNextEntry() {
        String string = null;
        if (this.currentFilePointer < this.archiveFileList.size()) {
            string = (String)this.archiveFileList.elementAt(this.currentFilePointer++);
        }
        return string;
    }

    public void reset() {
        this.currentFilePointer = 0;
    }

    public Vector listEntries() {
        return (Vector)this.archiveFileList.clone();
    }

    public void restoreFile(String string) throws IOException {
        String string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xPf " + this.archiveFileName + " " + string;
        try {
            EExecResult eExecResult = EExec.Exec((String)string2);
            if (eExecResult.rc != 0 || eExecResult.stderr.length() > 0) {
                if (eExecResult.rc != 0) {
                    throw new IOException("tar -xPf failure " + eExecResult.rc + "(" + eExecResult.stderr + ")");
                }
                throw new IOException("tar -xPf failure (" + eExecResult.stderr + ")");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("EExec failure");
        }
    }

    public void restoreArchive() throws IOException {
        String string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xPf " + this.archiveFileName;
        try {
            EExecResult eExecResult = EExec.Exec((String)string);
            if (eExecResult.rc != 0 || eExecResult.stderr.length() > 0) {
                if (eExecResult.rc != 0) {
                    throw new IOException("tar -xPf failure " + eExecResult.rc + "(" + eExecResult.stderr + ")");
                }
                throw new IOException("tar -xPf failure (" + eExecResult.stderr + ")");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("EExec failure");
        }
    }

    public void restoreArchiveX(String string) throws IOException {
        block6: {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                String string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("tar") + " -xPf " + this.archiveFileName + " -X " + string;
                try {
                    EExecResult eExecResult = EExec.Exec((String)string2);
                    if (eExecResult.rc != 0 || eExecResult.stderr.length() > 0) {
                        if (eExecResult.rc != 0) {
                            throw new IOException("tar -xPf <archive> -X failure " + eExecResult.rc + "(" + eExecResult.stderr + ")");
                        }
                        throw new IOException("tar -xPf <archive> -X failure (" + eExecResult.stderr + ")");
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException("EExec failure");
                }
            }
            throw new IOException("restoreArchiveX failure - exclude filename does not exist");
        }
    }
}

